<?php

    Class extension_StaticPageUrl extends Extension{

        public function about(){
            return array('name' => 'Static Page Url',
                         'version' => '1.0',
                         'release-date' => '2011-03-11',
                         'author' => array('name' => 'Jordy Boezaard',
                                           'website' => 'http://www.bitterzoetmedia.nl',
                                           'email' => 'jordy@bitterzoetmedia.nl')
                         );
        }
        
        public function getSubscribedDelegates(){
            return array(
                        array(
                            'page' => '/frontend/',
                            'delegate' => 'FrontendParamsResolve',
                            'callback' => 'addSessionValuesToPageParam'
                        ),                      
            );
        }   

        public function addSessionValuesToPageParam($context)
        {
            $parsedUrl = $context['params']['parent-path'];
            
            if (strlen($parsedUrl) > 1) $parsedUrl .= '/';
            
            $parsedUrl .= $context['params']['current-page'];
            
            if (strlen($parsedUrl) > 1) $parsedUrl .= '/';
            
            $context['params']['static-page-url'] = $parsedUrl;
            
            
            $sCurPathWithoutQuery = $context['params']['current-path'];
            $iQuestionmarkPos = strpos($sCurPathWithoutQuery, '?');
            
            if ($iQuestionmarkPos !== FALSE)
            {
                $sCurPathWithoutQuery = substr($sCurPathWithoutQuery, 0, $iQuestionmarkPos);
            }
            
            $context['params']['current-path-without-query'] = $sCurPathWithoutQuery;
            
            return;
        }
    }