<?php

    Class extension_Duplicate_Form_Submit extends Extension{

        public function about(){
            return array('name' => 'Duplicate Form Submit',
                         'version' => '1.0',
                         'release-date' => '2012-07-05',
                         'author' => array('name' => 'Jordy Boezaard',
                                           'website' => 'http://www.bitterzoetmedia.nl',
                                           'email' => 'jordy@bitterzoetmedia.nl')
                         );
        }

        public function getSubscribedDelegates() {
            return array(
                array(
                    'page' => '/blueprints/events/new/',
                    'delegate' => 'AppendEventFilter',
                    'callback' => 'appendEventFilter'
                ),
                array(
                    'page' => '/blueprints/events/edit/',
                    'delegate' => 'AppendEventFilter',
                    'callback' => 'appendEventFilter'
                ),
                array(
                    'page' => '/frontend/',
                    'delegate' => 'EventPreSaveFilter',
                    'callback' => 'eventPreSaveFilter'
                ),
                array(
                    'page' => '/frontend/',
                    'delegate' => 'EventPostSaveFilter',
                    'callback' => 'eventPostSaveFilter'
                ),
            );
        }

        public function appendEventFilter(array $context) {
            $context['options'][] = array(
                'duplicate-form-submit-fail',
                is_array($context['selected']) ? in_array('duplicate-form-submit-fail', $context['selected']) : false,
                'Filter Duplicate Form Submit: Fail if form is re-submitted in less then 1 minute'
            );
        }

        public function eventPreSaveFilter(array $context) {
            if(!in_array('duplicate-form-submit-fail', $context['event']->eParamFILTERS)) return;

            // Valid form submit
            $bValid = true;
            
            // Read session var
            $sesDupFormSubmit = $_SESSION[__SYM_COOKIE_PREFIX_ . 'duplicate-form-submit'];
        
            if (isset($sesDupFormSubmit) && !empty($sesDupFormSubmit))
            {
                // Check elapsed time
                $time1 = intval($sesDupFormSubmit);
                
                // Longer then 1 minute ago ?
                if (time() - $time1 < 60)
                {
                    $bValid = false;
                }
            }

            // "fail" filter
            if($bValid === false) {
                $context['messages'][] = array(
                    'duplicate-form-submit-fail', FALSE, 'Form re-submitted in less then 60 seconds'
                );
            }
        }
        
        public function eventPostSaveFilter(array $context) {
                $_SESSION[__SYM_COOKIE_PREFIX_ . 'duplicate-form-submit'] = time();
        }
    }